################################################################################
# GIGA-BYTE TECHNOLOGY CO.,LTD.
# No. 6, Bau Chiang Road, Hsin-Tien,
# Taipei Hsien, Taiwan, R.O.C.
# (c) Copyright 2020, GIGA-BYTE TECHNOLOGY CO.,LTD.
#
# All rights reserved.
# Abstract:
#    This file is a main class handles restore AMI BMC default password.
#
# Version: 0.01
# Python version: 3.6.8 or newer
#
#    Revision History:
#     Who        When          What
#   _______    __________    _______________
#   Sam.C      31-01-2020    new creation for restore default password tool.
################################################################################

import os #line:20
import sys #line:21
import argparse #line:22
import re #line:23
import subprocess #line:24
def help ():#line:29
    print ("Usage:")#line:30
    print ("    python",os .path .basename (__file__ ),"<Input File> <Start IP> <End IP>")#line:31
    print ("    optional arguments: -h, --help")#line:32
    sys .exit ()#line:33
def get_arguments ():#line:38
    O000OOOO00OO000O0 =argparse .ArgumentParser ()#line:39
    O000OOOO00OO000O0 .add_argument ("input_file",help ="File containing list of BMC information, each entry must be in format IPMI MAC, unique password in this order separated by commas",type =str ,nargs ="?",)#line:43
    O000OOOO00OO000O0 .add_argument ("start_IP",help ="Start of IP range",type =str ,nargs ="?")#line:47
    O000OOOO00OO000O0 .add_argument ("end_IP",help ="End of IP range",type =str ,nargs ="?")#line:51
    OO0OOO0OO00000OOO =O000OOOO00OO000O0 .parse_args ()#line:53
    OO0O0O0O000000OOO =OO0OOO0OO00000OOO .input_file #line:54
    O0O000OO0O0OOO000 =OO0OOO0OO00000OOO .start_IP #line:55
    OO0O0000O0OO0O00O =OO0OOO0OO00000OOO .end_IP #line:56
    return OO0O0O0O000000OOO ,O0O000OO0O0OOO000 ,OO0O0000O0OO0O00O #line:58
def parse_input_file (OOOOOOOO000000000 ):#line:63
    OOO000000O0O0O00O =dict ()#line:64
    O0OOOO000O00000O0 =[]#line:65
    try :#line:68
        with open (OOOOOOOO000000000 ,"r")as OO0O000000OO0O000 :#line:69
            for O0000O000O0OOOOO0 in OO0O000000OO0O000 :#line:70
                O0000O000O0OOOOO0 =O0000O000O0OOOOO0 .rstrip ()#line:71
                O0OOOOO00O0OOOOOO =O0000O000O0OOOOO0 .split (",")#line:72
                if len (O0OOOOO00O0OOOOOO )!=2 :#line:74
                    O0OOOO000O00000O0 .append (O0000O000O0OOOOO0 )#line:75
                else :#line:76
                    OO0O00OOO000OOOOO =O0OOOOO00O0OOOOOO [0 ].lower ().replace (":","")#line:77
                    OOO000000O0O0O00O [OO0O00OOO000OOOOO ]=O0OOOOO00O0OOOOOO [1 ]#line:78
    except Exception as O00O000OO0OO0OO00 :#line:79
        print (O00O000OO0OO0OO00 )#line:80
        sys .exit ()#line:81
    if len (O0OOOO000O00000O0 )!=0 :#line:83
        print ("\nERROR: Invalid data in input file:")#line:84
        for OO00O0O0O0OOO0000 in O0OOOO000O00000O0 :#line:85
            print (OO00O0O0O0OOO0000 )#line:86
        sys .exit ()#line:87
    return OOO000000O0O0O00O #line:89
def get_ip_list (O0O0O0OO00OO0000O ,OO00OOOO000OOOO0O ):#line:94
    OO0O0O0O000O0OO0O =[]#line:95
    O0OO0OO0O0O0OOOOO =re .compile ("^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$")#line:96
    O0000O0OOO00OOO0O =O0O0O0OO00OO0000O .split (".")#line:97
    O0O00OO0OO000O000 =OO00OOOO000OOOO0O .split (".")#line:98
    OOOOO00000OO0OOOO =O0000O0OOO00OOO0O [-1 ]#line:99
    O0O0O0OOO0OOO0OOO =O0O00OO0OO000O000 [-1 ]#line:100
    if (not (re .match (O0OO0OO0O0O0OOOOO ,O0O0O0OO00OO0000O ))):#line:103
        sys .exit ("ERROR: Start IP is not correct IP address format")#line:104
    if (not (re .match (O0OO0OO0O0O0OOOOO ,OO00OOOO000OOOO0O ))):#line:105
        sys .exit ("ERROR: End IP is not correct IP address format")#line:106
    if O0000O0OOO00OOO0O [:-1 ]!=O0O00OO0OO000O000 [:-1 ]:#line:107
        sys .exit ("ERROR: IP range not in the same domain")#line:108
    if int (O0O0O0OOO0OOO0OOO )<int (OOOOO00000OO0OOOO ):#line:109
        sys .exit ("ERROR: End IP is smaller than Start IP")#line:110
    for OOO0O0OO0OO0O0O0O in range (int (OOOOO00000OO0OOOO ),(int (O0O0O0OOO0OOO0OOO ))+1 ):#line:113
        OO0O0OO00OOOO0OO0 =O0000O0OOO00OOO0O [0 ]+"."+O0000O0OOO00OOO0O [1 ]+"."+O0000O0OOO00OOO0O [2 ]+"."+str (OOO0O0OO0OO0O0O0O )#line:114
        print ("Find ",OO0O0OO00OOOO0OO0 ,end =" >>> ",flush =True )#line:115
        O0000000O00OOO0O0 =subprocess .call (f"ping -c 3 {OO0O0OO00OOOO0OO0}",shell =True ,stdout =subprocess .PIPE )#line:116
        if O0000000O00OOO0O0 ==0 :#line:117
            print ("found")#line:118
            OO0O0O0O000O0OO0O .append (OO0O0OO00OOOO0OO0 )#line:119
        elif O0000000O00OOO0O0 ==2 :#line:120
            print ("no response from",OO0O0OO00OOOO0OO0 )#line:121
        else :#line:122
            print ("not found")#line:123
    return OO0O0O0O000O0OO0O #line:125
def get_ip_mac_table (OO0OO0OO00O0O0OO0 ):#line:130
    OO00O0O00OO0O0OOO =dict ()#line:131
    OO00O00OO00OO0O0O =[]#line:132
    OO000O000O0O00000 =[]#line:133
    OOOOO00OO0OO000O0 =re .compile ("[a-fA-F0-9:-]{17}|[a-fA-F0-9]{12}")#line:134
    print ("\nSystem Checking ...")#line:137
    for OOO0OO0OO0OO0OOOO in OO0OO0OO00O0O0OO0 :#line:138
        subprocess .call (f"ping -c 1 {OOO0OO0OO0OO0OOOO}",shell =True ,stdout =subprocess .PIPE )#line:139
        OOOOOOOO00OO0OO0O =subprocess .Popen (f"arp -a {OOO0OO0OO0OO0OOOO}",shell =True ,stdout =subprocess .PIPE )#line:140
        OOOOOOOO0O0000OOO ,OO0O0O00OO0000O0O =OOOOOOOO00OO0OO0O .communicate ()#line:141
        OOOOOOOO0O0000OOO =OOOOOOOO0O0000OOO .decode ("utf-8").lower ()#line:142
        if ("no match found"in OOOOOOOO0O0000OOO or "no arp entries found"in OOOOOOOO0O0000OOO or "incomplete"in OOOOOOOO0O0000OOO ):#line:143
            OO000O000O0O00000 .append (f"{OOO0OO0OO0OO0OOOO}\t not found")#line:144
        else :#line:145
            OO00O00OO00OO0O0O .append (f"{OOO0OO0OO0OO0OOOO}\t {re.findall(OOOOO00OO0OO000O0, OOOOOOOO0O0000OOO)[0]}")#line:146
            OO00O0O00OO0O0OOO [OOO0OO0OO0OO0OOOO ]=((re .findall (OOOOO00OO0OO000O0 ,OOOOOOOO0O0000OOO )[0 ]).replace (":","").lower ())#line:147
    print ("\nFound list: ")#line:149
    for O000000OOO000000O in OO00O00OO00OO0O0O :#line:150
        print (O000000OOO000000O )#line:151
    print ("\n")#line:152
    return OO00O0O00OO0O0OOO #line:154
def get_ip_pwd_table (OOOOO0OOOO00O00OO ,OOO00O0O0OOOO0OOO ):#line:159
    O00O000O000000000 =dict ()#line:160
    for OO000000OO0OO00OO in OOO00O0O0OOOO0OOO :#line:161
        if OOO00O0O0OOOO0OOO [OO000000OO0OO00OO ]in OOOOO0OOOO00O00OO :#line:162
            O00O000O000000000 [OO000000OO0OO00OO ]=OOOOO0OOOO00O00OO [OOO00O0O0OOOO0OOO [OO000000OO0OO00OO ]]#line:163
    return O00O000O000000000 #line:165
def restore_password (O00OO0000O00O0O00 ):#line:170
    OOO00OOOO0OO00O0O =[]#line:171
    O00OO000O00OO000O =[]#line:172
    for OOO0O0OO0OO0OOOO0 in O00OO0000O00O0O00 :#line:174
        O0O0O0000OO0O00O0 =f"ipmitool -H {OOO0O0OO0OO0OOOO0} -U admin -P {O00OO0000O00O0O00[OOO0O0OO0OO0OOOO0]} raw 0x2e 0x10 0x0a 0x3c 0 50 0x00"#line:175
        O00O0OOO000O000OO =subprocess .Popen (O0O0O0000OO0O00O0 ,shell =True ,stdout =subprocess .PIPE )#line:176
        O0OOOO00O0OO0O00O =O00O0OOO000O000OO .stdout .read ().decode ("utf-8").replace ("\n","").replace (" ","")#line:177
        if (O0OOOO00O0OO0O00O =="0a3c00"):#line:179
            OOO00OOOO0OO00O0O .append (OOO0O0OO0OO0OOOO0 )#line:180
            print (f"{OOO0O0OO0OO0OOOO0} success")#line:181
        else :#line:182
            O00OO000O00OO000O .append (OOO0O0OO0OO0OOOO0 )#line:183
            print (f"{OOO0O0OO0OO0OOOO0} fail")#line:184
    if len (OOO00OOOO0OO00O0O )!=0 :#line:186
        print ("\nRestore OK")#line:187
        for O00O00OO00OOOO0OO in OOO00OOOO0OO00O0O :#line:188
            print (O00O00OO00OOOO0OO )#line:189
    if len (O00OO000O00OO000O )!=0 :#line:190
        print ("\nRestore NG")#line:191
        for O00O00OO00OOOO0OO in O00OO000O00OO000O :#line:192
            print (O00O00OO00OOOO0OO )#line:193
def main ():#line:198
    if len (sys .argv )!=4 and sys .argv [-1 ]!="-h"and sys .argv [-1 ]!="--help":#line:199
        help ()#line:200
    O00OO0O00OOO00O00 ,O0O0OOOO0O0OOO00O ,OOO0O000OO0OOOOO0 =get_arguments ()#line:202
    OO0000000O0O00000 =parse_input_file (O00OO0O00OOO00O00 )#line:203
    OO0O0OOOO00OOOO0O =get_ip_list (O0O0OOOO0O0OOO00O ,OOO0O000OO0OOOOO0 )#line:204
    O0O00O00O000OOOO0 =get_ip_mac_table (OO0O0OOOO00OOOO0O )#line:205
    O00000O000O000O00 =get_ip_pwd_table (OO0000000O0O00000 ,O0O00O00O000OOOO0 )#line:206
    restore_password (O00000O000O000O00 )#line:207
    print ("\nRestore Done")#line:209
if __name__ =="__main__":#line:211
    main ()#line:212
